/*
 * Decompiled with CFR 0.152.
 */
package snake;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JFrame;
import javax.swing.JPanel;
import snake.Food;
import snake.LoadImage;
import snake.MKListen;
import snake.Snake;

public class mainGame
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -2170434274000730026L;
    private static GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private static int w = gd.getDisplayMode().getWidth();
    private static int h = gd.getDisplayMode().getHeight() - 40;
    public static int scale = 3;
    public static final int WIDTH = w / 3 - w / 3 % 10;
    public static final int HEIGHT = h / 3 - h / 3 % 10;
    public static int UPS = 10;
    private boolean running = false;
    private int ups = 0;
    private int fps = 0;
    private Point[] grass;
    private BufferedImage dbImage = new BufferedImage(WIDTH, HEIGHT, 1);
    private BufferedImage[][] texture;
    private Graphics2D dbG = (Graphics2D)this.dbImage.getGraphics();
    private Thread thread = new Thread((Runnable)this, "Game Runner");
    private JFrame frame;
    private Snake snake;
    private MKListen mkListen = new MKListen();
    private Insets insets;
    private LoadImage loadImage = new LoadImage();
    private Food f;

    public mainGame() {
        this.texture = new BufferedImage[2][4];
        int i = 1;
        while (i < 2) {
            int j = 1;
            while (j < 4) {
                this.texture[i][j] = new BufferedImage(32, 32, 1);
                ++j;
            }
            ++i;
        }
        this.texture = this.loadImage.getImage(this.getClass().getResource("/res/Textures.png"), this.texture, 2, 4, 32);
        this.grass = new Point[20];
        System.out.println(String.valueOf(WIDTH) + " | " + HEIGHT);
    }

    public int getUPS() {
        return this.ups;
    }

    public int getFPS() {
        return this.fps;
    }

    public void start() {
        this.running = true;
        this.f = new Food();
        int i = 0;
        while (i < this.grass.length) {
            this.grass[i] = new Point((int)(Math.random() * (double)WIDTH) - 16, (int)(Math.random() * (double)HEIGHT) - 16);
            ++i;
        }
        if (this.insets == null) {
            this.insets = this.frame.getInsets();
        }
        this.insets.top /= scale;
        this.insets.bottom /= scale;
        this.insets.right /= scale;
        this.insets.left /= scale;
        System.out.println("top:" + this.insets.top + " right:" + this.insets.right + " bottom:" + this.insets.bottom + " left:" + this.insets.left);
        this.snake = new Snake();
        this.thread.start();
    }

    @Override
    public void run() {
        long lastTime = System.nanoTime();
        long startTime = System.currentTimeMillis();
        double delta = 0.0;
        double ns = 1000000000 / UPS;
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / ns;
            lastTime = System.nanoTime();
            if (delta > 1.0) {
                ++this.ups;
                this.update();
                this.render();
                delta -= 1.0;
            }
            this.drawToScreen();
            ++this.fps;
            if (System.currentTimeMillis() - startTime <= 1000L) continue;
            startTime += 1000L;
            this.frame.setTitle("Snake 1.0 || UPS:" + this.ups + " | FPS:" + this.fps);
            this.ups = 0;
            this.fps = 0;
        }
        this.close();
    }

    public void update() {
        if (this.f.getP().x + this.f.getP().y == 0) {
            this.f.generateFood(this.snake);
        }
        if (this.mkListen.isQuit()) {
            this.running = false;
        }
        if (this.snake.isDead()) {
            if (this.mkListen.isProceed()) {
                this.snake.restart();
                this.f.remove();
            }
        } else {
            this.snake.update(this.mkListen, this.f);
        }
    }

    public void render() {
        this.dbG.setColor(new Color(100, 168, 45));
        this.dbG.fillRect(0, 0, WIDTH, HEIGHT);
        Point[] pointArray = this.grass;
        int n = this.grass.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            this.dbG.drawImage((Image)this.texture[0][0], p.x, p.y, null);
            ++n2;
        }
        this.snake.render(this.dbG);
        this.f.render(this.dbG);
        if (this.snake.isDead()) {
            this.dead();
        }
    }

    public void dead() {
        this.dbG.setColor(Color.RED);
        this.dbG.setFont(new Font("Chiller", 1, 45));
        int len = (int)this.dbG.getFontMetrics().getStringBounds("YOU ARE DEAD!!!", this.dbG).getWidth();
        this.dbG.drawString("YOU ARE DEAD!!!", (WIDTH - len) / 2, HEIGHT / 2 - 20);
        this.dbG.setFont(new Font("Century Gothic", 1, 12));
        len = (int)this.dbG.getFontMetrics().getStringBounds("Press 'SPACE to continue OR 'Q' for closing", this.dbG).getWidth();
        this.dbG.drawString("Press 'SPACE to continue OR 'Q' for closing", (WIDTH - len) / 2, 3 * HEIGHT / 4 - 20);
        this.drawToScreen();
    }

    public void drawToScreen() {
        BufferedImage image = new BufferedImage(this.frame.getWidth(), this.frame.getHeight(), 1);
        Graphics2D g = (Graphics2D)this.frame.getGraphics();
        int[] dbPixels = ((DataBufferInt)this.dbImage.getRaster().getDataBuffer()).getData();
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < HEIGHT * scale) {
            int j = 0;
            while (j < WIDTH * scale) {
                pixels[i * mainGame.WIDTH * mainGame.scale + j] = dbPixels[i / scale * WIDTH + j / scale];
                ++j;
            }
            ++i;
        }
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
    }

    public void close() {
        this.running = false;
        System.out.println("Game Stopping...");
        try {
            this.thread.join(100L);
            this.dbG.dispose();
            System.out.println("Game Stopped");
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        mainGame game = new mainGame();
        game.frame = new JFrame("Snake 1.0");
        game.frame.setPreferredSize(new Dimension(WIDTH * scale, HEIGHT * scale));
        game.frame.pack();
        game.frame.setDefaultCloseOperation(3);
        game.frame.setVisible(true);
        game.frame.add(game);
        game.frame.addKeyListener(game.mkListen);
        game.start();
    }
}

